﻿using System.Net;
using System.Threading.Tasks;
using System.Windows;

namespace SchedulerContext
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        void OnButtonClick(object sender, RoutedEventArgs e)
        {
            // Listing 16-22. Tworzenie zadania realizującego metodę APM
            TaskScheduler uiScheduler = TaskScheduler.FromCurrentSynchronizationContext();
            Task<IPHostEntry>.Factory.FromAsync(
                                Dns.BeginGetHostEntry, Dns.EndGetHostEntry,
                                "helion.pl", null)
                .ContinueWith((task) => UpdateUi(task.Result.AddressList[0].ToString()),
                              uiScheduler);
        }

        void UpdateUi(string info)
        {
            myTextBox.Text = info;
        }
    }
}
